/* GCC */
#include<iostream>
#include<cstdio>
#include<vector>
#include<queue>
#include<map>

using namespace std;

const int N = 2500+1, M = 5000+1, SZ = 50+1;

long long gcd(long long a, long long b){
    while(b){
        long long w = a%b;
        a = b;
        b = w;
    }
    return a;
}

struct fraction{
    long long num, den;
    void s(){
        long long g = gcd(num, den);
        num /= g;
        den /= g;
        if(den < 0){
            num = -num;
            den = -den;
        }
    }
    fraction(long long num=0, long long den=1):num(num), den(den){
        s();
    }
    fraction operator-(){
        return fraction(-num, den);
    }

    fraction operator+=(const fraction& f){
        num = num*f.den + den*f.num;
        den = den*f.den;
        s();
        return (*this);
    }
    fraction operator-=(const fraction& f){
        num = num*f.den - den*f.num;
        den = den*f.den;
        s();
        return (*this);
    }
    fraction operator*=(const fraction& f){
        num = num*f.num;
        den = den*f.den;
        s();
        return (*this);
    }
    fraction operator/=(const fraction& f){
        num = num*f.den;
        den = den*f.num;
        s();
        return (*this);
    }

    bool operator==(const fraction& f)const{
        return (num*f.den == den*f.num);
    }
    bool operator!=(const fraction& f)const{
        return (num*f.den != den*f.num);
    }
    bool operator<(const fraction& f)const{
        return (num*f.den < den*f.num);
    }
    bool operator<=(const fraction& f)const{
        return (num*f.den <= den*f.num);
    }
    bool operator>(const fraction& f)const{
        return (num*f.den > den*f.num);
    }
    bool operator>=(const fraction& f)const{
        return (num*f.den >= den*f.num);
    }
};
fraction operator+(fraction a, const fraction& b){
    return (a += b);
}
fraction operator-(fraction a, const fraction& b){
    return (a -= b);
}
fraction operator*(fraction a, const fraction& b){
    return (a *= b);
}
fraction operator/(fraction a, const fraction& b){
    return (a /= b);
}
ostream& operator<<(ostream& os, const fraction& f){
    os << f.num;
    if(f.den > 1)
        os << '/' << f.den;
    return os;
}
istream& operator>>(istream& is, fraction& f){
    is >> f.num >> f.den;
    return is;
}

int sz;
fraction matrix[SZ][SZ];

void print_matrix(){
    for(int i = 0; i < sz; ++i){
        for(int j = 0; j <= sz; ++j)
            cout << matrix[i][j] << ' ';
        cout << endl;
    }
}

void gauss(){
    for(int i = 0; i < sz; ++i){
        if(matrix[i][i] == 0)
            for(int j = i+1; j < sz; ++j)
                if(matrix[j][i] != 0){
                    swap(matrix[i], matrix[j]);
                    break;
                }
        for(int j = i+1; j < sz; ++j){
            fraction c = matrix[j][i] / matrix[i][i];
            for(int k = i; k <= sz; ++k)
                matrix[j][k] -= matrix[i][k] * c;
        }
    }
    for(int i = sz-1; i >= 0; --i){
        fraction c = (matrix[i][sz] /= matrix[i][i]);
        matrix[i][i] = 1;
        for(int j = i-1; j >= 0; --j){
            matrix[j][sz] -= matrix[j][i] * c;
            matrix[j][i] = 0;
        }
    }
}

int pos = 1;
int head[N], deg[N];
int dest[M], nxt[M], prv[M], ind[M], sgn[M];
fraction weight[M];
map<pair<int, int>, int> emap;
void add(int v, int u, fraction w){
    if(emap.find({v, u}) != emap.end()){
        int i = emap[{v, u}];
        weight[i] = 1/(1/weight[i] + 1/w);
    }
    else{
        nxt[++pos] = head[v];
        prv[nxt[pos]] = pos;
        head[v] = pos;
        dest[pos] = u;
        weight[pos] = w;
        ind[pos] = -1;
        sgn[pos] = 1;
        ++deg[v];
        emap[{v, u}] = pos;
    }

    if(emap.find({u, v}) != emap.end()){
        int i = emap[{u, v}];
        weight[i] = 1/(1/weight[i] + 1/w);
    }
    else{
        nxt[++pos] = head[u];
        prv[nxt[pos]] = pos;
        head[u] = pos;
        dest[pos] = v;
        weight[pos] = w;
        ind[pos] = -1;
        sgn[pos] = 1;
        ++deg[u];
        emap[{u, v}] = pos;
    }
}

void del(int v, int u){
    int i;

    i = emap[{v, u}];
    nxt[prv[i]] = nxt[i];
    prv[nxt[i]] = prv[i];
    if(head[v] == i)
        head[v] = nxt[i];
    --deg[v];
    emap.erase({v, u});

    i = emap[{u, v}];
    nxt[prv[i]] = nxt[i];
    prv[nxt[i]] = prv[i];
    if(head[u] == i)
        head[u] = nxt[i];
    --deg[u];
    emap.erase({u, v});
}

int n, m;

int d[N];
bool zero_bfs(){
    for(int i = 1; i < n; ++i)
        d[i] = -1;
    d[0] = 0;
    queue<int> q;
    q.push(0);
    while(!q.empty()){
        int v = q.front();
        q.pop();
        for(int i = head[v]; i; i = nxt[i]){
            int u = dest[i];
            if(weight[i] != 0 || d[u] != -1)
                continue;
            if(u == n-1)
                return true;
            d[u] = d[v] + 1;
            q.push(u);
        }
    }
    return false;
}

int from[N];
bool bfs(){
    for(int i = 1; i < n; ++i){
        d[i] = -1;
        from[i] = -1;
    }
    d[0] = 0;
    from[0] = 0;
    queue<int> q;
    q.push(0);
    while(!q.empty()){
        int v = q.front();
        q.pop();
        for(int i = head[v]; i; i = nxt[i]){
            int u = dest[i];
            if(d[u] != -1)
                continue;
            d[u] = d[v] + 1;
            from[u] = v;
            q.push(u);
        }
    }
    return d[n-1] != -1;
}

int eq, now_ind;
vector<pair<pair<int, int>, fraction> > path;
bool used[N];
void dfs(int v=0){
    used[v] = true;
    for(int i = head[v]; i; i = nxt[i]){
        int u = dest[i];
        if(ind[i] != -1)
            continue;
        ind[i]   = now_ind;
        ind[i^1] = now_ind;
        ++now_ind;
        if(used[u]){
            sgn[i] = -1;
            int j = 0;
            while(path[j].first.first != u)
                ++j;
            for(; j < path.size(); ++j)
                matrix[eq][path[j].first.second] = path[j].second;
            matrix[eq][ind[i]] = -weight[i];
            ++eq;
            continue;
        }
        sgn[i^1] = -1;
        path.push_back({{v, ind[i]}, weight[i]});
        dfs(u);
        path.pop_back();
    }
}

int main(){
    freopen("resistor.in", "r", stdin);
    freopen("resistor.out", "w", stdout);
    ios_base::sync_with_stdio(false);
    cout.tie(0);
    cin.tie(0);
    cin >> n >> m;
    for(int i = 0; i < m; ++i){
        int v, u;
        fraction w;
        cin >> v >> u >> w;
        --v; --u;
        add(v, u, w);
    }
    bool updated = true;
    while(updated){
        updated = false;
        for(int i = 1; i < n-1; ++i){
            if(deg[i] != 2)
                continue;
            fraction w = weight[head[i]] + weight[nxt[head[i]]];
            int v = dest[head[i]],
                u = dest[nxt[head[i]]];
            del(i, v);
            del(i, u);
            add(v, u, w);
        }
    }
    if(emap.size() == 2){
        cout << weight[head[0]] << endl;
        return 0;
    }
    if(zero_bfs()){
        cout << 0 << endl;
        return 0;
    }
    if(!bfs()){
        cout << "Zero conductivity" << endl;
        return 0;
    }
    sz = emap.size()/2;
    dfs();
    int v = n-1;
    while(v != 0){
        int u = from[v];
        int i = emap[{u, v}];
        matrix[eq][ind[i]] = weight[i];
        v = u;
    }
    matrix[eq][sz] = 1;
    ++eq;
    for(int i = 1; i < n-1; ++i){
        for(int j = head[i]; j; j = nxt[j])
            matrix[eq][ind[j]] = sgn[j];
        ++eq;
    }
    gauss();
    fraction ans(0, 1);
    for(int i = head[0]; i; i = nxt[i]){
        int j = ind[i];
        ans += matrix[j][sz];
    }
    ans = 1/ans;
    cout << ans << endl;
}
