/* GCC */
#include <bits/stdc++.h>
using namespace std;

int GCD(int a, int b){
    if(a < b)
        swap(a, b);
    while(b){
        a %= b;
        swap(a, b);
    }
    return a;
}


struct frac{
    long long t, b;

    void simplify(){
        long long gcd = GCD(t, b);
        t /= gcd;
        b /= gcd;
    }


    frac(long long Top, long long Bot){
        t = Top, b = Bot;
        long long gcd = GCD(t, b);
        t /= gcd;
        b /= gcd;
    }
};

struct resistor{
    int to;
    frac F;

};


frac operator +(frac a, frac b){
    frac c = frac(a.t*b.b + b.t*a.b, a.b*b.b);
    c.simplify();
    return c;
}

frac operator -(frac a, frac b){
    frac c = frac(a.t*b.b - b.t*a.b, a.b*b.b);
    c.simplify();
    return c;
}

frac operator *(frac a, frac b){
    frac c = frac(a.t*b.t, a.b*b.b);
    c.simplify();
    return c;
}

frac operator /(frac a, frac b){
    frac c = frac(a.t*b.b, a.b*b.t);
    c.simplify();
    return c;
}

bool operator ==(frac a, frac b){
    return (a.t == b.t) && (a.b == b.b);
}

frac paralel(frac a, frac b){
    frac c = a*b/(a+b);
    c.simplify();
    return c;
}

void bfs(vector<vector<resistor> > vec, bool used[]){
    queue<int> q;
    q.push(1);
    while(!q.empty()){
        used[q.front()] = 1;
        for(int i = 0; i < vec[q.front()].size(); i++)
            if(!used[vec[q.front()][i].to])
                q.push(vec[q.front()][i].to);
        q.pop();
    }
}

bool operator <(resistor a, resistor b){
    return a.to < b.to;
}

int main()
{
    //freopen("resistor.in", "r", stdin);
    //freopen("resistor.out", "w", stdout);
    cin.tie(0);
    cout.tie(0);
    ios_base::sync_with_stdio(0);
    int N, M;
    cin >> N >> M;
    bool used[2501] = {0};
    vector<vector<resistor> > vec(N + 1);
    for(int i = 0, a, b, c, d; i < M; i++){
        cin >> a >> b >> c >> d;
        vec[a].push_back({b, frac(c, d)});
        vec[b].push_back({a, frac(c, d)});
    }
    bfs(vec, used);
    if(used[N] == 0){
        cout << "Zero conductivity";
        return 0;
    }
    bool flag = 1;
    for(int i = 1; i <= N; i++)
        sort(vec[i].begin(), vec[i].end());
    while(flag){
        flag = 0;
        for(int i = 1; i <= N; i++){
            for(int j = vec[i].size() - 1; j > 0; j--){
                if(vec[i][j].to == vec[i][j - 1].to){
                    flag = 1;
                    int to = vec[i][j-1].to;
                    frac res = paralel(vec[i][j].F, vec[i][j-1].F);
                    for(int k = vec[to].size() - 1, cnt1 = 0, cnt2 = 0; k >= 0 && (cnt1 != 1 || cnt2!= 1); k--){
                        if(vec[to][k].F == vec[i][j-1].F && vec[to][k].to == i && cnt1 == 0){
                            cnt1++;
                            vec[to][k].F = res;
                            continue;
                        }
                        if(vec[to][k].F == vec[i][j].F && vec[to][k].to == i && cnt2 == 0){
                            cnt2++;
                            vec[to].erase(vec[to].begin() + k);
                        }
                    }
                    vec[i][j-1].F = res;
                    vec[i].erase(vec[i].begin() + j);
                }
            }
            if(vec[i].size() <= 2){
                if(vec[vec[i][0].to].size() == 2){
                    flag = 1;
                    if(vec[vec[i][0].to][0].to == i ){
                        vec[i].push_back({vec[vec[i][0].to][1].to, frac(vec[i][0].F + vec[vec[i][0].to][1].F)});
                        vec[vec[vec[i][0].to][1].to].push_back({i , frac(vec[i][0].F + vec[vec[i][0].to][1].F)});
                        int to = vec[vec[i][0].to][1].to;
                        for(int k = 0; k < vec[to].size(); k++)
                            if(vec[to][k].to == vec[i][0].to)
                                vec[to].erase(vec[to].begin() + k);
                        }
                    else{
                        vec[i].push_back({vec[vec[i][0].to][0].to, frac(vec[i][0].F + vec[vec[i][0].to][0].F)});
                        vec[vec[vec[i][0].to][0].to].push_back({i , frac(vec[i][0].F + vec[vec[i][0].to][1].F)});
                        int to = vec[vec[i][0].to][0].to;
                        for(int k = 0; k < vec[to].size(); k++)
                            if(vec[to][k].to == vec[i][0].to)
                                vec[to].erase(vec[to].begin() + k);
                    }
                    vec[vec[i][0].to].clear();
                    vec[i].erase(vec[i].begin());
                }
                if(vec[i].size() == 2 && vec[vec[i][1].to].size() == 2){
                    flag = 1;
                    if(vec[vec[i][1].to][0].to == i){
                        vec[i].push_back({vec[vec[i][1].to][1].to, frac(vec[i][1].F + vec[vec[i][1].to][1].F)});
                        vec[vec[vec[i][1].to][1].to].push_back({i , frac(vec[i][0].F + vec[vec[i][0].to][1].F)});
                        int to = vec[vec[i][1].to][1].to;
                        for(int k = 0; k < vec[to].size(); k++)
                            if(vec[to][k].to == vec[i][1].to)
                                vec[to].erase(vec[to].begin() + k);
                        }
                    else{
                        vec[i].push_back({vec[vec[i][1].to][0].to, frac(vec[i][1].F + vec[vec[i][1].to][0].F)});
                        vec[vec[vec[i][1].to][0].to].push_back({i , frac(vec[i][0].F + vec[vec[i][0].to][1].F)});
                        int to = vec[vec[i][1].to][0].to;
                        for(int k = 0; k < vec[to].size(); k++)
                            if(vec[to][k].to == vec[i][1].to)
                                vec[to].erase(vec[to].begin() + k);
                    }

                    vec[vec[i][1].to].clear();
                    vec[i].erase(vec[i].begin() + 1);
                }
                if(vec[i].size() == 2 && vec[i][0].to > vec[i][1].to)
                    swap(vec[i][0], vec[i][1]);
            }
        }
    }
    for(int i = 0; i < vec[1].size(); i++)
        if(vec[1][i].to == N){
            cout << vec[1][i].F.t;
            if(vec[1][i].F.b != 1)
                cout << '/' << vec[1][i].F.b;
            cout << '\n';
            return 0;
        }
    cout << 1;
    return 0;
}
