/*GCC*/
#include <bits/stdc++.h>

using namespace std;

typedef long long ll;

const int Nmax = 3000;
struct number {
    int a, b;
    number(int pa, int pb) {
        int g = __gcd(pa, pb);
        if(g) {
            pa /= g;
            pb /= g;
        }
        a = pa;
        b = pb;
        if(b < 0) {
            a = -a;
            b = -b;
        }
    }
    number() {
        a = 0;
        b = 1;
    }
    void read() {
        cin >> a >> b;
        int g = __gcd(a, b);
        if(g) {
            a /= g;
            b /= g;
        }
        if(b < 0) {
            a = -a;
            b = -b;
        }
    }
    void write() {
        cout << a;
        if(b != 1)
            cout << '/' << b;
    }
};

number operator-(number a, number b) {
    return number(a.a*b.b - b.a*a.b, a.b*b.b);
}
number operator+(number a, number b) {
    return number(a.a*b.b + b.a*a.b, a.b*b.b);
}
number operator*(number a, number b) {
    return number(a.a*b.a, a.b*b.b);
}
number operator/(number a, number b) {
    return number(a.a*b.b, a.b*b.a);
}
bool operator == (number a, number b) {
    return a.a == b.a && a.b == b.b;
}
bool operator == (number a, int b) {
    return a.a == b && a.b == 1;
}

void update_par(number &a, number b) {
    if(a == 0 || b == 0)
        a = number(0, 1);
    else
        a = a * b / (a + b);
}
int n;
map<pair<int, int>, number> hM;
map<pair<int, int>, int> num;
set<int> gs[Nmax];
vector<int> g[Nmax];
vector<vector<number> > equality;
void del(int v) {
    if(v == 0 || v == n-1)
        return;
    if(gs[v].size() == 1) {
        int hv = *gs[v].begin();
        gs[hv].erase(gs[hv].find(v));
        gs[v].clear();
        del(hv);
    }
    else
    if(gs[v].size() == 2) {
        int a = *gs[v].begin();
        int b = *(++gs[v].begin());

        gs[a].insert(b);
        gs[b].insert(a);
        if(hM.count(make_pair(a, b)))
            update_par(hM[make_pair(a, b)],  hM[make_pair(a, v)] + hM[make_pair(v, b)]);
        else
            hM[make_pair(a, b)] = hM[make_pair(a, v)] + hM[make_pair(v, b)];
        hM[make_pair(b, a)] = hM[make_pair(a, b)];

        gs[a].erase(gs[a].find(v));
        gs[b].erase(gs[b].find(v));
        gs[v].clear();
        del(a);
        del(b);
    }
}
bool used[Nmax];
bool dfs(int v, bool ch) {
    used[v] = 1;
    if(ch)
    for(int i = 0;i < g[v].size();++i) {
        if(!used[g[v][i]] && hM[make_pair(v, g[v][i])] == 0 && dfs(g[v][i], true))
            return true;
    }

    for(int i = 0;i < g[v].size();++i) {
        if(!used[g[v][i]])
             dfs(g[v][i], false);
    }
    return false;
}

int m;
vector<pair<int, int> > edges;
void way(int v) {
    used[v] = true;
    if(v == n-1) {
        number hv;
        equality.push_back(vector<number>(m+1, number(0, 1)));
        for(int j = 0;j < edges.size();++j) {
            hv = hM[edges[j]];
            if(edges[j].first < edges[j].second)
                hv = number(-1, 1) * hv;
            equality[equality.size()-1][num[edges[j]]] = hv;
        }
        equality[equality.size()-1][m] = number(-1, 1);
        used[v] = false;
        return;
    }

    for(int i = 0;i < g[v].size();++i) {
        if(!used[g[v][i]]) {
            edges.push_back(make_pair(v, g[v][i]));
            way(g[v][i]);
            edges.pop_back();
        }
    }
    used[v] = false;
}
int main() {
    freopen("resistor.in", "r", stdin);
    freopen("resistor.out", "w", stdout);

    ios_base::sync_with_stdio(false);
    cin.tie(0);
    cout.tie(0);

    cin >> n >> m;

    int a, b;
    number p, hv;
    for(int i = 0;i < m;++i) {
        cin >> a >> b;
        p.read();
        if(a == b)
            continue;
        a--, b--;
        gs[a].insert(b);
        gs[b].insert(a);
        if(hM.count(make_pair(a, b)))
            update_par(hM[make_pair(a, b)], p);
        else
            hM[make_pair(a, b)] = p;
        hM[make_pair(b, a)] = hM[make_pair(a, b)];
    }

    for(int i = 1;i < n-1;++i)
        del(i);

    m = 0;
    int cnt = 0;
    for(int i = 0;i < n;++i) {
        for(set<int>::iterator it = gs[i].begin();it != gs[i].end();++it) {
            g[i].push_back(*it);
            if(*it > i) {
                num[make_pair(*it, i)] = cnt;
                num[make_pair(i, *it)] = cnt;
                cnt++;
            }
            m++;
        }
        gs[i].clear();
    }
    m >>= 1;
    if(dfs(0, true)) {
        cout << "0\n";
        return 0;
    }
    if(!used[n-1]) {
        cout << "Zero conductivity\n";
        return 0;
    }

    for(int i = 1;i < n-1;++i) {
        if(g[i].empty())
            continue;

        equality.push_back(vector<number>(m+1, number(0, 1)));
        for(int j = 0;j < g[i].size();++j) {
            if(g[i][j] < i)
                hv = number(-1, 1);
            else
                hv = number(1, 1);
            equality[equality.size()-1][num[make_pair(g[i][j], i)]] = hv;
        }
    }
    for(int i = 0;i < n;++i)
        used[i] = 0;
    way(0);
    for(int i = 0;i < m;++i) {
        if(equality[i][i] == 0)
        for(int j = i+1;j < equality.size();++j) {
            if(equality[j][j] == 0)
                continue;
            equality[j][i];
            swap(equality[i], equality[j]);
        }
        for(int j = i+1;j <= m;++j)
            equality[i][j] = equality[i][j] / equality[i][i];
        equality[i][i] = number(1, 1);
        for(int j = 0;j < equality.size();++j) {
            if(j == i)
                continue;
            for(int k = i+1;k <= m;++k)
                equality[j][k] = equality[j][k] - equality[i][k] * equality[j][i];
            equality[j][i] = number(0, 1);
        }
    }


    number cur = number(0, 1);
    for(int i = 0;i < g[0].size();++i) {
        cnt = num[make_pair(0, g[0][i])];
        cur = cur + equality[cnt][m];
    }

    (number(1, 1) / cur).write();
    cout << '\n';
    return 0;
}
