/* GCC */
#include <iostream>
#include <stdio.h>
#include <vector>

using namespace std;

#define MAXN 3000

struct frac
{
    int num, denom;
};

int n, m;
vector< pair<int, frac> > G[MAXN];
vector< pair<int, frac> > OG[MAXN];
frac Dp[MAXN];
int Q[MAXN];
bool Used[MAXN];

frac rev(frac a)
{
    if (a.num == 0) return a;
    frac res;
    res.num = a.denom;
    res.denom = a.num;
    return res;
}

int abs(int a)
{
    if (a < 0) a *= -1;
    return a;
}

int GCD(int a, int b)
{
    a = abs(a); b = abs(b);
    while ((a != 0) && (b != 0)){
        if ((a == 1) || (b == 1)) return 1;
        if (b > a) b %= a;
        else a %= b;
    }
    return a+b;
}

frac operator +(frac a, frac b)
{
    frac c;
    c.num = a.num*b.denom + b.num*a.denom;
    c.denom = a.denom*b.denom;
    int gcd = GCD(c.num, c.denom);
    c.num /= gcd;
    c.denom /= gcd;
    return c;
}

frac DP(int v, int p)
{
    //cout << " " << v << "\n";

    if (Dp[v].num != -1) return Dp[v];
    frac f;

    if (v == n){
        f.num = 0;
        f.denom = 1;
        return f;
    }

    int to;
    frac r, t;
    f.num = 0; f.denom = 1;
    for (int i=0; i<OG[v].size(); i++){
        to = OG[v][i].first;
        r = OG[v][i].second;
        if (to == p) continue;
        t = r + DP(to, v);
        f = f + rev(t);
    }

    Dp[v] = rev(f);
  //  cout << " " << v << "  " << Dp[v].num << "/" << Dp[v].denom << "\n";
    return Dp[v];
}

int main(void)
{
    freopen("resistor.in", "r", stdin);
    freopen("resistor.out", "w", stdout);

    scanf("%d%d", &n, &m);
    int a, b, ch, zn;
    frac f;
    for (int i=0; i<m; i++){
        scanf("%d%d%d%d", &a, &b, &ch, &zn);
        f.num = ch;
        f.denom = zn;
        G[a].push_back( make_pair(b, f) );
        G[b].push_back( make_pair(a, f) );
    }

    for (int i=0; i<MAXN; i++) Used[i] = false;
    int start=0, finish=0, v, to;
    frac r;
    Q[finish] = 1; finish++;
    bool inf = true;
    Used[1] = true;
    while (start < finish){
        v = Q[start]; start++;

        for (int i=0; i<G[v].size(); i++){
            to = G[v][i].first;
            r  = G[v][i].second;

            for (int j=0; j<OG[to].size(); j++)
                if (OG[to][j].first == v) { Used[to] = true; break; }
            if (Used[to]) continue;

            if (to == n) inf = false;

            OG[v].push_back( make_pair(to, r) );

            Q[finish] = to; finish++;
        }
    }

    if (inf){
        printf("Zero conductivity\n");
        return 0;
    }
/*
    for (int v=1; v<=n; v++){
        cout << v << " -> ";
        for (int i=0; i<OG[v].size(); i++)
            printf("(%d, %d)  ", OG[v][i].first, OG[v][i].second.num, OG[v][i].second.denom);
        cout << endl;
    }
*/
    for (int i=0; i<MAXN; i++) Dp[i].num = -1;

    frac ans;
    ans = DP(1, 0);

    if (ans.denom == 1) printf("%d\n", ans.num);
    else printf("%d/%d\n", ans.num, ans.denom);

    return 0;
}
