/* GCC */
#include <bits/stdc++.h>

using namespace std;

int nsd(int a, int b) {
    if (a == 0 || b == 0) return a + b;
    if (a > b) return nsd (a % b, b);
    return nsd(b % a, a);
}

int n,m;

struct num {
    int f,g;
public:
    num operator+(num a);
    num operator-(num a);
    num operator*(num a);
    num operator/(num a);
    num tonum(int a);
};

num tonum(int a) {
    num res;
    res.f = a;
    res.g = 1;
    return res;
}

num num::operator+(num a) {
    num res;
    int ff = f*a.g + a.f*g;
    int gg = g*a.g;
    int d = nsd(ff,gg);
    ff/=d; gg/=d;
    if (gg < 0) {ff *= -1; gg *=-1;}
    res.f = ff;
    res.g = gg;
    return res;
}

num num::operator-(num a) {
    num res;
    int ff = f*a.g - a.f*g;
    int gg = g*a.g;
    int d = nsd(ff,gg);
    ff/=d; gg/=d;
    if (gg < 0) {ff *= -1; gg *=-1;}
    res.f = ff;
    res.g = gg;
    return res;
}

num num::operator*(num a) {
    num res;
    int ff = f*a.f;
    int gg = g*a.g;
    int d = nsd(ff,gg);
    ff/=d; gg/=d;
    if (gg < 0) {ff *= -1; gg *=-1;}
    res.f = ff;
    res.g = gg;
    return res;
}

num num::operator/(num a) {
    num res;
    int ff = f*a.g;
    int gg = g*a.f;
    int d = nsd(ff,gg);
    ff/=d; gg/=d;
    if (gg < 0) {ff *= -1; gg *=-1;}
    res.f = ff;
    res.g = gg;
    return res;
}

bool comp(pair<int, num> a, pair<int, num> b) {
    return a.first < b.first;
}

vector <pair<int, num> > graph[2600];
vector <num> p;
int use[3000];

bool dfs(int v) {
    use[v] = 1;
    for (int i = 0; i < graph[v].size(); i++) if (!use[graph[v][i].first]) dfs(graph[v][i].first);
    return use[n];
}


int main()
{
    ifstream fin("resistor.in");
    ofstream fout("resistor.out");
    int t1,t2;
    num t;
    fin >> n >> m;
    for (int i = 0; i < m; i++) {
        fin >> t1 >> t2 >> t.f >> t.g;
        graph[t1].push_back(make_pair(t2, t));
        graph[t2].push_back(make_pair(t1, t));
    }
    if (!dfs(1)) {
        fout << "Zero conductivity" << endl;
        return 0;
    }
    for (int i = 1; i <= n; i++) {
        sort(graph[i].begin(), graph[i].end(), comp);
    }
    for (int k = 0; k < 50; k++) {
        for (int i = 1; i <= n; i++) {
            for (int j = 1; j < graph[i].size(); j++) {
                if(graph[i][j].first == graph[i][j - 1].first) {
                    num r1 = graph[i][j-1].second, r2 = graph[i][j].second;
                    graph[i][j-1].second = r1*r2/(r1+r2);
                    graph[i].erase(graph[i].begin() + j);
                }
            }
        }
    }
    num res = tonum(0);
    for (int i = 1; i <= n; i++) {
        for (int j = 0; j < graph[i].size(); j++) {
            res = res + graph[i][j].second;
        }
    }
    res = res / tonum(2);
    if(res.g != 1) fout << res.f << '/' << res.g;
    else fout << res.f;
    fout << endl;
    return 0;
}







