/* GCC */
#include <bits/stdc++.h>
using namespace std;
int n, m;
struct drob
{
    int x, y;
};

int gcd(int a, int b)
{
    a = abs(a);
    b = abs(b);

    while(a != 0 && b != 0)
    {
        if(a > b)
            a %= b;
        else
            b %= a;
    }
    return a + b;
}

drob make_drob(int a, int b)
{
    drob c;
    int g = gcd(a, b);
    a/= g;
    b/= g;
    c.x = a;
    c.y = b;
    return c;
}

bool operator<(drob a, drob b)
{
    return a.x * b.y < a.y * b.x;
}

drob operator+(drob a, drob b)
{
    int chis = a.x * b.y + a.y * b.x, znam = b.y * a.y;
    return make_drob(chis, znam);
}

drob operator/(int a, drob b)
{
    swap(b.x, b.y);
    return b;
}

vector<set<pair<int, drob> > > R;
vector<bool> used;

void dfs(int ap)
{
    used[ap] = true;
    set<pair<int, drob> >::iterator it;
    for(it = R[ap].begin(); it != R[ap].end(); it++)
    {
        int to = (*it).first;
        if(!used[to])
            dfs(to);
    }
}

void OutPutDrob(drob a)
{
    if(a.y == 1)
        cout<< a.x << "\n";
    else
        cout<< a.x << "/" << a.y << "\n";
}

int main()
{
    freopen("resistor.in", "r", stdin);
    freopen("resistor.out", "w", stdout);
    cin>> n >> m;
    R.resize(n);
    used.resize(n, false);
    for(int i = 0; i < m; i++)
    {
        int a, b;
        cin>> a >> b;
        drob c;
        cin>> c.x >> c.y;
        R[a - 1].insert(make_pair(b - 1, c));
        R[b - 1].insert(make_pair(a - 1, c));
    }

    dfs(0);

    if(!used[n - 1])
    {
        cout<< "Zero conductivity\n";
        return 0;
    }
    set<pair<int, drob> >:: iterator it;
    drob res = make_drob(0, 1);
    bool control = false;

    for(it = R[0].begin(); it != R[0].end(); it++)
    {
        if((*it).second.x == 0)
        {
            control = true;
            break;
        }
        else
            res = res + (1 / (*it).second);
    }

    if(control)
    {
        cout<< 0 << "\n";
        return 0;
    }

    OutPutDrob(1 / res);

    return 0;
}
