/* GCC */
#include <iostream>
#include <stdio.h>
#include <queue>
#include <vector>
#include <string.h>
#include <cmath>

using namespace std;

struct fract{
    int num;
    int den;
};

int gcd(int a, int b){
    a = abs(a);
    b = abs(b);
    while (a > 0 && b > 0){
        int c = a%b;
        a = b;
        b = c;
    }
    return ((a+b==0)? 1 : a+b);
}

void sim(fract& f){
    int g = gcd(f.num, f.den);
    f.num/=g;
    f.den/=g;
}

fract f_summ(fract f1, fract f2){
    fract f;
    f.num = f1.num*f2.den+f1.den*f2.num;
    f.den = f1.den*f2.den;
    sim(f);
    return f;
}

fract f_mult(fract f1, fract f2){
    fract f;
    f.num = f1.num*f2.num;
    f.den = f1.den*f2.den;
    sim(f);
    return f;
}

fract f_d(fract f1, fract f2){
    fract f;
    f.num = f1.num*f2.den;
    f.den = f1.den*f2.num;
    sim(f);
    return f;
}

int main(){
    freopen("resistor.in", "r", stdin);
    freopen("resistor.out", "w", stdout);
    int n, m;
    scanf("%d%d", &n, &m);

    vector<fract> v[n];
    for (int i = 0; i < n; i++){
        v[i].resize(n);
        for (int j = 0; j < n; j++){
            v[i][j].num = -1;
            v[i][j].den = 0;
        }
    }

    for (int i = 0; i < m; i++){
        int p1, p2;
        fract sam;
        scanf("%d%d%d%d", &p1, &p2, &sam.num, &sam.den);
        if (p1 == p2) continue;
        p1--;
        p2--;
        sim(sam);
        if (v[p1][p2].den == 0){
            v[p1][p2] = sam;
        } else {
            v[p1][p2] = f_d(f_mult(v[p1][p2], sam), f_summ(v[p1][p2], sam));
        }
        v[p2][p1] = v[p1][p2];
    }

    fclose(stdin);

    queue<int> q, rb;
    int stv[2600], tmp;
    memset(stv, 0, sizeof(stv));
    q.push(0);
    stv[0] = 1;
    while(!q.empty()){
        tmp = q.front();
        q.pop();

        for (int i = 0; i < n; i++){
            if (v[tmp][i].num == 0 && stv[i] == 0){
                stv[i] = 1;
                q.push(i);
            }
        }
    }
    if (stv[n-1] == 1){
        printf("0\n");
        fclose(stdout);
        return 0;
    }
    memset(stv, -1, sizeof(stv));
    q.push(0);
    stv[0] = 0;
    while(!q.empty()){
        tmp = q.front();
        q.pop();

        for(int i = 0; i < n; i++){
            if(v[tmp][i].den != 0){
                stv[tmp]++;
                if (stv[i] == -1){
                    stv[i] = 0;
                    q.push(i);
                }
            }
        }
        if (stv[tmp] == 1 && tmp != 0 && tmp != n-1){
            rb.push(tmp);
        }
    }
    if (stv[n-1] == -1){
        printf("Zero conductivity\n");
        fclose(stdout);
        return 0;
    }

    while(!rb.empty()){
        tmp = rb.front();
        rb.pop();

        if (v[stv[tmp]][tmp].den == 0){
            for (int i = 0; i < n; i++){
                if (v[tmp][i].den != 0){
                    stv[tmp] = i;
                    break;
                }
            }
        }

        v[stv[tmp]][tmp].num = -1;
        v[stv[tmp]][tmp].den = 0;
        v[tmp][stv[tmp]].num = -1;
        v[tmp][stv[tmp]].den = 0;

        stv[stv[tmp]]--;
        if (stv[stv[tmp]] == 1){
            rb.push(stv[tmp]);
        }
    }
    int p1 = 1;
    vector<int> w;
    while(p1){
        p1 = 0;
        for (int i = 1; i < n-1; i++){
            if(stv[i] == 2){
                p1= 1;
                q.push(i);
            }
        }
        while(!q.empty()){
            tmp = q.front();
            q.pop();
            w.clear();

            for (int i = 0; i < n; i++){
                if(v[tmp][i].den != 0){
                    w.push_back(i);
                }
            }
            int x1 = w[0];
            int x2 = w[1];
            fract sam = f_summ(v[tmp][x1], v[tmp][x2]);
            v[x1][tmp].den = 0;
            v[x2][tmp].den = 0;
            v[tmp][x1].den = 0;
            v[tmp][x2].den = 0;

            stv[x1]--;
            stv[x2]--;
            stv[tmp] = 0;
            if (v[x1][x2].den == 0){
                v[x1][x2] = sam;
            } else {
                v[x1][x2] = f_d(f_mult(v[x1][x2], sam), f_summ(v[x1][x2], sam));
            }
            v[x2][x1] = v[x1][x2];
        }
    }
    printf("%d", v[0][n-1].num);
    if (v[0][n-1].den != 1){
        printf("/%d", v[0][n-1].den);
    }
    printf("\n");
    fclose(stdout);
    return 0;
}
















